// Face Tracking.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

// usage: facedetect --cascade=<path> image_name
#include "cv.h"
#include "highgui.h"
#include <string>
#include <string.h>

using namespace std;

int main( int argc, char** argv )
{
   CvHaarClassifierCascade* cascade;
   
   // face sequence will reside in the storage
   CvMemStorage* storage=cvCreateMemStorage(0);
   IplImage *image;
   CvSeq* faces;
   int optlen = strlen("--cascade=");
   int i;
   string outputfilename = "";
   bool exitWhenFinished = false;
   if( argc < 3 ||
       strncmp(argv[1], "--cascade=", optlen) )
       return -1;
   i=0;

   while(i<argc)
   {
	   if(string(argv[i]) == string("-x"))
	   {
			exitWhenFinished = true;
	   }
	   if(string(argv[i]) == string("-o"))
	   {
			outputfilename = string(argv[i+1]);

			exitWhenFinished = true;
	   }
	   i++;
   }
   // load classifier cascade from XML file
   cascade = (CvHaarClassifierCascade*)
       cvLoad( argv[1] + optlen );
   // load image from the specified file
   image = cvLoadImage( argv[2], 1 );

   if( !cascade || !image )
       return -1;

   
   // get the sequence of face rectangles
   faces = cvHaarDetectObjects( image,
     cascade, storage,
     1.2, // scale the cascade
          // by 20% after each pass
     2, // groups of 3 (2+1) or more neighbor face rectangles are joined into a single "face", smaller groups are rejected
     CV_HAAR_DO_CANNY_PRUNING, // use Canny edge detector to reduce number of false alarms
     cvSize(0, 0) // start from the minimum face size allowed by the particular classifier
    );
    
   FILE* file = fopen(outputfilename.c_str(), "wb");
   if (file) { 
   // for each face draw the bounding rectangle
   for(i=0;i<(faces ? faces->total:0); i++ ) {
      CvRect* r = (CvRect*)
           cvGetSeqElem( faces, i );
      CvPoint pt1 = { r->x, r->y };
      CvPoint pt2 = { r->x + r->width,
                      r->y + r->height };
      cvRectangle( image, pt1, pt2,
                   CV_RGB(255,0,0), 3, 8, 0 );
	  fprintf(file,"%d %d %d %d\n",r->x, r->y, r->x + r->width, r->y + r->height);
   }
   fclose(file);
   }


   // create window and show the image with outlined faces
   cvNamedWindow( "faces", 1 );
   cvShowImage( "faces", image );
   if (!exitWhenFinished) {
   char* filename = "JacekFace.jpg";
   cvSaveImage(filename, image);
   cvWaitKey();
   }

   // after a key pressed, release data
   cvReleaseImage( &image );
   cvReleaseHaarClassifierCascade( &cascade );
   cvReleaseMemStorage( &storage );
   return 0;
}


